<?php 
/*-----------------------------------------------------------------------------------*/
/** Call to Action
/*-----------------------------------------------------------------------------------*/

if ( ! defined( 'ABSPATH' ) ) { exit; }
class WPBakeryShortCode_Apress_Callto_Action extends WPBakeryShortCode {}

$doc_link = 'http://apressthemes.com/apress/documentation';

if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
					"name"				=> __("Call to Action", 'apcore'),
					"base"				=> "apress_callto_action",
					"class"				=> "",
					"weight"			=> 5,
					"category"			=> __( "Apress", "apcore"),
					"description"		=> __( "Eye Catching call to action", "apcore"),
					"icon"				=> APRESS_EXTENSIONS_PLUGIN_URL . "vc_custom/assets/images/vc_icons/vc-icon-calltoaction.png",
					"params" 			=> array(	
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("Call to Action Style",'apcore'),
							"description"		=> __("Choose Box Design",'apcore'),
							"param_name"		=> "calltoaction_style",
							"value"				=> array (
								"Style 1" => "style1",
								"Style 2" => "style2"
							), 
							'admin_label'		=> true,							
						),
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Box Top & Bottom Padding",'apcore'),
							"param_name"		=> "calltoaction_topbottom_pad",
							'step'				=> '1',
							'value'				=> '30',
							'suffix'			=> 'px',
							"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
						),
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Box Left & Right Padding",'apcore'),
							"param_name"		=> "calltoaction_leftright_pad",
							'step'				=> '1',
							'value'				=> '30',
							'suffix'			=> 'px',						
							"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
						),
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Box Title",'apcore'),
							"description"		=> __("Enter the Title for the Box",'apcore'),
							"param_name"		=> "calltoaction_title",
							"value"				=> 'Box Title',							
						),
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Title Font Size",'apcore'),
							"param_name"		=> "calltoaction_title_size",
							'step'				=> '1',
							'value'				=> '24',
							'suffix'			=> 'px',
							"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
						),
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Title Line Height",'apcore'),
							"param_name"		=> "calltoaction_title_lineheight",
							'step'				=> '1',
							'value'				=> '28',
							'suffix'			=> 'px',
							"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
						),						
						array(
							"type"				=> "textarea",
							"class"				=> "",
							"heading"			=> __("Box Description",'apcore'),
							"param_name"		=> "calltoaction_text",
							"value"				=> __("Text for the module",'apcore'),
							"description"		=> __("Text for the module",'apcore'),
						),
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("Text Align",'apcore'),
							"param_name"		=> "calltoaction_textalign",
							"value" 			=> array ("Left" => "left","Right" => "right","Center" => "center"),
							"description" 		=> __("Choose the box text align",'apcore'),
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Title color",'apcore'),
							"description"		=> __("Choose the Title color",'apcore'),
							"param_name"		=> "calltoaction_titlecolor",
							"value"				=> '#777777',	
							'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc apress-number-wrap',						
						),
						array(
							"type" 				=> "colorpicker",
							"class"  			=> "",
							"heading"  			=> __("Text color",'apcore'),
							"param_name"  		=> "calltoaction_textcolor",
							"value"  			=> '#777777',
							"description"  		=> __("Choose the Text color",'apcore'),
							'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc apress-number-wrap',
						),							
						array(
							"type" 				=> "colorpicker",
							"class"  			=> "",
							"heading"  			=> __("Box Background color",'apcore'),
							"param_name"  		=> "calltoaction_boxbgcolor",
							"value"  			=> '#f7f7f7',
							"description"  		=> __("Choose the box background color",'apcore'),
							'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc apress-number-wrap',
						),							
						array(
							"type" 				=> "attach_image",
							"class" 			=> "",
							"heading" 			=> __("Background Image", "apcore"),
							"param_name" 		=> "imagebox_image",
							"value" 			=> "",
							"description" 		=> __("Choose the box background Image",'apcore'),
						),
						array(
							"type" 				=> "textfield",
							"class"  			=> "",
							"heading"  			=> __("Top Border Width",'apcore'),
							"param_name"  		=> "calltoaction_top_borderwidth",
							"value"  			=> '1',
							"description"  		=> __("Enter the box top border Width",'apcore'),
							"edit_field_class"	=> "vc_column vc_col-sm-3 no-border-bottom",
						),
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Right Border Width",'apcore'),
							"description"		=> __("Enter the box Right border Width",'apcore'),
							"param_name"		=> "calltoaction_right_borderwidth",
							"value"				=> '1',							
							"edit_field_class"	=> "vc_column vc_col-sm-3 no-border-bottom",
						),
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Bottom Border Width",'apcore'),
							"description"		=> __("Enter the box bottom border Width",'apcore'),
							"param_name"		=> "calltoaction_bottom_borderwidth",
							"value"				=> '1',							
							"edit_field_class"	=> "vc_column vc_col-sm-3 no-border-bottom",
						),	
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Left Border Width",'apcore'),
							"param_name"		=> "calltoaction_left_borderwidth",
							"value"				=> '1',
							"description"		=> __("Enter the box left border Width",'apcore'),
							"edit_field_class"	=> "vc_column vc_col-sm-3 no-border-bottom",
						),							
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Box Border color",'apcore'),
							"description"		=> __("Choose the box Border color",'apcore'),
							"param_name"		=> "calltoaction_boxbordercolor",
							"value"				=> '#f0f0f0',							
						),
						array(
							'type'				=> 'zolo_param_heading',
							'text'				=> esc_html__('Button Design', 'apcore'),
							'param_name'		=> 'Button_design_heading',
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-top-margin',
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
						),	
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("Button Position",'apcore'),
							"description"		=> __("Choose Button Style",'apcore'),
							"param_name"		=> "calltoaction_buttonposi",
							"value"				=> array (
								"Right" => "button_posi_right",
								"Left" => "button_posi_left",
								"Bottom" => "button_posi_bottom"
								),							
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
						),
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("Button Size",'apcore'),
							"param_name"		=> "calltoaction_button_size",
							"value"				=> array (
								"Small" => "small",
								"Medium" => "medium", 
								"Large" => "large" 
							), 
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
						),
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Button text",'apcore'),
							"param_name"		=> "calltoaction_button_text",
							"value"				=> 'Button text',
							"description"		=> __("Enter the button text",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
						),
						array(
							"type" 				=> "dropdown",
							"class" 			=> "",
							"heading" 			=> __("Button Style",'apcore'),
							"param_name" 		=> "calltoaction_buttonstyle",
							"value" 			=> array ("Square" => "square","Rounded" => "rounded"),
							"description" 		=> __("Choose Button Style",'apcore'),
							'dependency' 		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
						),
						array(
							"type" 				=> "dropdown",
							"class" 			=> "",
							"heading" 			=> __("Button Hover Style",'apcore'),
							"param_name" 		=> "calltoaction_button_hoverstyle",
							"value" 			=> array (
								"Hover Style 1" => "hoverstyle1",
								"Hover Style 2" => "hoverstyle2",
								"Hover Style 3" => "hoverstyle3",
								"Hover Style 4" => "hoverstyle4",
								"Hover Style 5" => "hoverstyle5"
							),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')), 
						),
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Button Border Radius",'apcore'),
							"param_name"		=> "calltoaction_button_border_radius",
							"value" 			=> '50',
							'dependency'		=> array( 'element' => 'calltoaction_buttonstyle', 'value' => array('rounded')),
						),
						array(
							"type"				=> "vc_link",
							"class"				=> "",
							"heading"			=> __("Button Link",'apcore'),
							"param_name"		=> "calltoaction_button_link",
							"description"		=> __("http://example.com",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
						 ),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Button Font color",'apcore'),
							"param_name"		=> "calltoaction_buttonfontcolor",
							"value" 			=> '#666666',
							"description"		=> __("Choose the button font color",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
							'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Button Hover Font color",'apcore'),
							"param_name"		=> "calltoaction_buttonfontcolorhover",
							"value" 			=> '#666666',
							"description"		=> __("Choose the Button hover Font color",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
							'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
						),							
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Button Background color",'apcore'),
							"param_name"		=> "calltoaction_buttonbgcolor",
							"value" 			=> '#ebebeb',
							"description"		=> __("Choose the Button background color",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
							'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Button Hover Background color",'apcore'),
							"param_name"		=> "calltoaction_buttonbgcolorhover",
							"value" 			=> '#dcdcdc',
							"description"		=> __("Choose the Button hover background color",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
							'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Button Border color",'apcore'),
							"param_name"		=> "calltoaction_buttonbordercolor",
							"value" 			=> '#e6e6e6',
							"description"		=> __("Choose the Button Border color",'apcore'),
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
							'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Button Hover Border color",'apcore'),
							"description"		=> __("Choose the Button hover border color",'apcore'),
							"param_name"		=> "calltoaction_buttonbordercolorhover",
							"value" 			=> '#ebebeb',							
							'dependency'		=> array( 'element' => 'calltoaction_style', 'value' => array('style1')),
							'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
						),
						array(
							'type'				=> 'zolo_param_heading',
							'text'				=> esc_html__('Extra features', 'apcore'),
							'param_name'		=> 'subtitle_margin_heading',
							'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
						),
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("CSS Animation",'apcore'),
							"param_name"		=> "data_animation",
							"value"				=> apress_data_animations(),
							"description"		=> __("Select type of animation. Note: Works only in modern browsers.",'apcore'),
							"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-8 no-top-margin",
						),  
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Delay","apcore"),
							"param_name"		=> "data_delay",
							"value"				=> "500",
							"description"		=> __("Delay","apcore"),
							"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-4 no-top-margin",
						),
						array(
							"type"				=> "textfield",
							"heading"			=> __("Extra class name", "apcore"),
							"param_name"		=> "class",
							"description"		=> __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "apcore")
						),
						array(
							'type'				=> 'zolo_video_link_param',
							'heading'			=> esc_html__('Video tutorial and theme documentation article','apcore'),
							'param_name'		=> 'tutorials',
							'doc_link'			=> $doc_link,
							'video_link'		=> 'https://youtu.be/Bxy6Po79bcA',
						),	
						array(
							'type'				=> 'zolo_param_heading',
							'text'				=> esc_html__('Title Style', 'apcore'),
							'param_name'		=> 'title_heading',
							'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
							'group'				=> esc_html__('Title Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_font_container',
							'heading'			=> '',
							'param_name'		=> 'title_font_options',
							'settings'				=> array(
								'fields'				=> array(
									'letter_spacing',
									'font_style',
								),
							),
							'group'			=> esc_html__('Title Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_radio_advanced',
							'heading'			=> esc_html__('Custom font family', 'apcore'),
							'param_name'		=> 'title_google_fonts',
							'value'				=> 'no',
							'options'			=> array(
								esc_html__('Yes', 'apcore')	=> 'yes',
								esc_html__('No', 'apcore') => 'no',
							),
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
							'group'				=> esc_html__('Title Style', 'apcore'),
						),
						array(
							'type'				=> 'google_fonts',
							'param_name'		=> 'title_custom_fonts',
							'settings'			=> array(
								'fields'			=> array(
									'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
									'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
								),
							),
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
							'dependency' => array( 'element' => 'title_google_fonts', 'value' => 'yes'),
							'group'				=> esc_html__('Title Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_param_heading',
							'text'				=> esc_html__('Description Style', 'apcore'),
							'param_name'		=> 'description_heading',
							'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
							'group'				=> esc_html__('Description Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_font_container',
							'heading'			=> '',
							'param_name'		=> 'description_font_options',
							'settings'				=> array(
								'fields'				=> array(
									'letter_spacing',
									'font_style',
								),
							),
							'group'			=> esc_html__('Description Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_radio_advanced',
							'heading'			=> esc_html__('Custom font family', 'apcore'),
							'param_name'		=> 'description_google_fonts',
							'value'				=> 'no',
							'options'			=> array(
								esc_html__('Yes', 'apcore')	=> 'yes',
								esc_html__('No', 'apcore') => 'no',
							),
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
							'group'				=> esc_html__('Description Style', 'apcore'),
						),
						array(
							'type'				=> 'google_fonts',
							'param_name'		=> 'description_custom_fonts',
							'settings'			=> array(
								'fields'			=> array(
									'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
									'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
								),
							),
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
							'dependency' => array( 'element' => 'description_google_fonts', 'value' => 'yes'),
							'group'				=> esc_html__('Description Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_param_heading',
							'text'				=> esc_html__('Button Style', 'apcore'),
							'param_name'		=> 'button_heading',
							'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
							'group'				=> esc_html__('Button Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_font_container',
							'heading'			=> '',
							'param_name'		=> 'button_font_options',
							'settings'				=> array(
								'fields'				=> array(
									'letter_spacing',
									'font_style',
								),
							),
							'group'			=> esc_html__('Button Style', 'apcore'),
						),
						array(
							'type'				=> 'zolo_radio_advanced',
							'heading'			=> esc_html__('Custom font family', 'apcore'),
							'param_name'		=> 'button_google_fonts',
							'value'				=> 'no',
							'options'			=> array(
								esc_html__('Yes', 'apcore')	=> 'yes',
								esc_html__('No', 'apcore') => 'no',
							),
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
							'group'				=> esc_html__('Button Style', 'apcore'),
						),
						array(
							'type'				=> 'google_fonts',
							'param_name'		=> 'button_custom_fonts',
							'settings'			=> array(
								'fields'			=> array(
									'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
									'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
								),
							),
							'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
							'dependency' => array( 'element' => 'button_google_fonts', 'value' => 'yes'),
							'group'				=> esc_html__('Button Style', 'apcore'),
						),

					),
				) );		
		
			}		