<?php 
/*-----------------------------------------------------------------------------------*/
/* Icon Boxes
/*-----------------------------------------------------------------------------------*/

if ( ! defined( 'ABSPATH' ) ) { exit; }
class WPBakeryShortCode_Apress_Icon_Box extends WPBakeryShortCode {}

$doc_link = 'http://apressthemes.com/apress/documentation';

if ( function_exists( 'vc_map' ) ) {
vc_map( array(
	"name"				=> __("Icon Box", 'apcore'),
	"base"				=> "apress_icon_box",
	"class"				=> "",
	"weight"			=> 9,
	"category"			=> __( "Apress", "apcore"),
	"description"		=> __( "Eye Catching Icon Box", "apcore"),
	"icon"				=> APRESS_EXTENSIONS_PLUGIN_URL . "vc_custom/assets/images/vc_icons/vc-icon-iconbox.png",
	"params" => array(																				
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Box Style",'apcore'),
				"description"		=> __("Choose Icon Box Style",'apcore'),
				"param_name"		=> "box_style",
				"value"				=> array (
					__("None",'apcore') => "box_style_none",
					__("Square",'apcore') => "box_style_square",
					__("Rounded",'apcore') => "box_style_rounded"
				),
				'admin_label'		=> true,
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Variation",'apcore'),
				"description"		=> __("Box Variation",'apcore'),
				"param_name"		=> "box_variation",
				"value"				=> array (
					__("Default",'apcore') => "default",
					__("Modern",'apcore') => "variation_modern"
				),				
				'dependency'		=> array( 'element' => 'box_style', 'value' => array('box_style_square', 'box_style_rounded'))
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Box Hover Style",'apcore'),
				"description"		=> __("Choose hover style",'apcore'),
				"param_name"		=> "box_hover_style",
				"value"				=> array (
					__("None",'apcore') => "box_hover_none",
					__("Fade",'apcore') => "box-fade",
					__("Flip Vertical",'apcore') => "box-flip-vertical"
				),				
				'admin_label'		=> true,
				'dependency'		=> array( 'element' => 'box_variation', 'value' => array('default'))
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Box Hover Style",'apcore'),
				"description"		=> __("Choose hover style",'apcore'),
				"param_name"		=> "box_hover_style1",
				"value"				=> array (
					__("None",'apcore') => "box_hover_none",
					__("Fade",'apcore') => "box-fade"
				),		
				'admin_label'		=> true,		
				"dependency"		=> array( "element" => "box_variation", "value"	=> array("variation_modern"))
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Background","apcore"),
				"description"		=> __("Choose Background Color","apcore"),
				"param_name"		=> "box_bg",
				"value"				=> "#f4f4f4",				
				"dependency"		=> array( "element" => "box_style", "value"=> array("box_style_square", "box_style_rounded")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Border","apcore"),
				"description"		=> __("Choose Border Color","apcore"),
				"param_name"		=> "box_border",
				"value"				=> "#a2a2a2", 				
				"dependency"		=> array( "element" => "box_style", "value" => array("box_style_square", "box_style_rounded")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Hover Background","apcore"),
				"description"		=> __("Choose Box Hover Color","apcore"),
				"param_name"		=> "box_hover_bg",
				"value"				=> "#00c3f3", 				
				"dependency"		=> array( "element" => "box_hover_style", "value"	=> array("box-fade","box-zoom","box-flip-vertical")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Hover Background","apcore"),
				"description"		=> __("Choose Box Hover Background","apcore"),
				"param_name"		=> "box_hover_bg1",
				"value"				=> "#00c3f3", 				
				"dependency"		=> array( "element" => "box_hover_style1", "value"	=> array("box-fade")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Hover Border","apcore"),
				"description"		=> __("Choose Box Hover Border","apcore"),
				"param_name"		=> "box_hover_border",
				"value"				=> "#00c3f3", 				
				"dependency"		=> array( "element" => "box_hover_style", "value"	=> array("box-fade","box-zoom","box-flip-vertical")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),	
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Hover Border","apcore"),
				"description"		=> __("Choose Box Hover Border","apcore"),
				"param_name"		=> "box_hover_border1",
				"value"				=> "#00c3f3", 				
				"dependency"		=> array( "element" => "box_hover_style1", "value"	=> array("box-fade")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),	
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Color","apcore"),
				"description"		=> __("Choose Icon Color","apcore"),
				"param_name"		=> "iconcolor",
				"value"				=> "#0088CC",				
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Hover Color","apcore"),
				"description"		=> __("Choose Icon Hover Color","apcore"),
				"param_name"		=> "icon_hover_color",
				"value"				=> "#cccccc", 				
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				'type'				=> 'zolo_number',
				'class'				=> '',
				'heading' 			=> esc_html__('Icon Size','apcore'),
				'param_name' 		=> 'icon_size',
				'value' 			=> '30',
				'suffix' 			=> 'PX',
				'edit_field_class' 	=> 'vc_column vc_col-sm-12',
			),						
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Background Shape",'apcore'),
				"description"		=> __("Select a background shape for your icon.",'apcore'),
				"param_name"		=> "icon_background_shape",
				"value"				=> array (
					__("None",'apcore') => "none",
					__("Square",'apcore') => "square",
					__("Circle",'apcore') => "circle",
					__("Rounded",'apcore') => "rounded",
					__("Diamond",'apcore') => "diamond"
				),				
				"dependency"		=> array( "element" => "box_style", "value" => array("box_style_none"))
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Background Shape","apcore"),
				"description"		=> __("Select a background shape for your icon.","apcore"),
				"param_name"		=> "variation_icon_bg_shape",
				"value"				=> array (
					__("Circle","apcore") => "circle",
					__("Diamond","apcore") => "diamond",
					__("Full width","apcore") => "full_width"
				),				
				"dependency"		=> array( "element" => "box_variation", "value" => array("variation_modern"))
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Background Shape Type","apcore"),
				"description"		=> __("Select a type of background shape for your icon. This is only applied when there are no hover effects.","apcore"),
				"param_name"		=> "icon_background_shape_type",
				"value"				=> array (
					__("Normal, solid background","apcore") => "solid_background",
					__("Thin bordered background","apcore") => "thin_bordered",
					__("Thick bordered background","apcore") => "thick_bordered"
				),				
				"dependency"		=> array( "element" => "icon_background_shape", "value" => array("square", "rounded", "circle","diamond"))
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Shadow","apcore"),
				"description"		=> __("Show / Hide Icon Shadow","apcore"),
				"param_name"		=> "icon_shadow",
				"value"				=> array (
					__("No","apcore") => "no",
					__("Yes","apcore") => "yes"
				),				
				"dependency"		=> array( "element" => "icon_background_shape", "value" => array("none"))
			),
			array(
				"type"				=> "zolo_number",
				"class"				=> "",
				"heading"			=> __("Icon Shape Size (This will act as height for icon background when Full width is choosen above)","apcore"),
				"param_name" 		=> "shape_size",
				"value"				=> "60",
				"suffix"			=> "PX",
				"edit_field_class"	=> "vc_column vc_col-sm-12",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Background & Border Shape Color","apcore"),
				"description"		=> __("Icon Background Color","apcore"),
				"param_name"		=> "shape_background_color",
				"value"				=> "#27b6fe", 				
				"dependency"		=> array( "element" => "icon_background_shape", "value"	=> array("square", "rounded", "circle","diamond")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),	
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Background","apcore"),
				"description"		=> __("Icon Background Color","apcore"),
				"param_name"		=> "variation_icon_bg_color",
				"value"				=> "#27b6fe", 				
				"dependency"		=> array( "element" => "box_variation", "value" => array("variation_modern")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Border Color","apcore"),
				"description"		=> __("Icon Hover Border Color","apcore"),
				"param_name"		=> "variation_icon_border_color",
				"value"				=> "#27b6fe", 				
				"dependency"		=> array( "element" => "box_variation", "value" => array("variation_modern")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),							
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Position","apcore"),
				"description"		=> __("Choose Icon Position","apcore"),
				"param_name"		=> "iconposition",
				"value"				=> array (
					__("Left","apcore") => "left",
					__("Right","apcore") => "right",
					__("Center","apcore") => "center"
				),				
				"dependency"		=> array( "element" => "icon_background_shape", "value" => array("none","square", "rounded", "circle","diamond"))
			),	
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Position","apcore"),
				"description"		=> __("Choose Icon Position","apcore"),
				"param_name"		=> "iconposition2",
				"value"				=> array (
					__("Left","apcore") => "left",
					__("Right","apcore") => "right",
					__("Center","apcore") => "center"
				),				
				"dependency"		=> array( "element" => "box_style", "value" => array("box_style_square", "box_style_rounded"))
			),	
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Hover Style","apcore"),
				"description"		=> __("Choose Icon Hover Style","apcore"),
				"param_name"		=> "iconhoverstyle1",
				"value"				=> array(__( "No hover effect", "apcore" ) => "none",
			"(faint-circle) " . __( "Faint background shape that solidifies on hover with an outline", "apcore" ) => "faint-circle",
			"(solid-outline) " . __( "Solid background shape that gets smaller when hovered on and shows a border", "apcore" ) => "solid-outline",
			"(flip-vertical) " . __( "Solid background shape, that flips vertically when hovered with inverted colors", "apcore" ) => "flip-vertical",
			"(flip-horizontal) " . __( "Solid background shape, that flips horizontally when hovered with inverted colors", "apcore" ) => "flip-horizontal",
			"(swipe-down) " . __( "Solid background shape, icon swipes down on hover and gets replaced with inverted colors", "apcore" ) => "swipe-down",
			"(swipe-up) " . __( "Solid background shape, icon swipes up on hover and gets replaced with inverted colors", "apcore" ) => "swipe-up",
			"(swipe-left) " . __( "Solid background shape, icon swipes left on hover and gets replaced with inverted colors", "apcore" ) => "swipe-left",
			"(swipe-right) " . __( "Solid background shape, icon swipes right on hover and gets replaced with inverted colors", "apcore" ) => "swipe-right",
							
						),				
				"dependency"		=> array( "element" => "icon_background_shape_type", "value" => array("solid_background"))
			),	
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("Icon Hover Style","apcore"),
				"description"		=> __("Choose Icon Hover Style","apcore"),
				"param_name"		=> "iconhoverstyle2",
				"value"				=> array(
				__( "No hover effect", "apcore" ) => "none",
				"(fill-up) " . __( "Outlined background shape that gets filled up from the bottom when hovered", "apcore" ) => "fill-up",
				"(border-solid) " . __( "Border background shape that gets filled up from the edges when hovered", "apcore" ) => "border-solid",
				"(border-Outline-thick) " . __( "Border background shape that gets smaller with another thicker border when hovered", "apcore" ) => "border-outline-thick",
				),				
				"dependency"		=> array( "element" => "icon_background_shape_type", "value" => array("thick_bordered", "thin_bordered"))
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Hover Background & Border Shape Color","apcore"),
				"description"		=> __("Choose Background and border color","apcore"),
				"param_name"		=> "icon_hover_bg_color",
				"value"				=> "#27b6fe", 
				"dependency"		=> array( "element" => "icon_background_shape", "value" => array("square", "rounded", "circle","diamond")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",		
			),	
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Icon Hover Color","apcore"),
				"param_name"		=> "box_icon_hover_color",
				"value"				=> "#ffffff", 
				"description"		=> __("Choose Icon Hover Color","apcore"),
				"dependency"		=> array( "element" => "box_hover_style", "value" => array("box-fade","box-zoom","box-flip-vertical")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Hover Background Color","apcore"),
				"param_name"		=> "variation_icon_hover_bg_color",
				"value"				=> "#27b6fe", 
				"description"		=> __("Choose Icon Hover Background Color","apcore"),
				"dependency"		=> array( "element" => "box_hover_style", "value" => array("box-flip-vertical")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),	
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Hover Border Color","apcore"),
				"description"		=> __("Choose Icon Hover Border Color","apcore"),
				"param_name"		=> "variation_icon_hover_border_color",
				"value"				=> "#27b6fe", 				
				"dependency"		=> array( "element" => "box_hover_style", "value" => array("box-flip-vertical")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),				
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Box Icon Hover Color","apcore"),
				"description"		=> __("Choose Text Hover Color","apcore"),
				"param_name"		=> "box_icon_hover_color1",
				"value"				=> "#ffffff", 				
				"dependency"		=> array( "element" => "box_hover_style1", "value" => array("box-fade")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Hover Background Color","apcore"),
				"description"		=> __("Choose Icon Hover Background Color","apcore"),
				"param_name"		=> "variation_icon_hover_bg_color1",
				"value"				=> "#27b6fe",				
				"dependency"		=> array( "element" => "box_hover_style1", "value" => array("box-fade")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),	
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Icon Hover Border Color","apcore"),
				"description"		=> __("Choose Icon Hover Border Color","apcore"),
				"param_name"		=> "variation_icon_hover_border_color1",
				"value"				=> "#27b6fe", 				
				"dependency"		=> array( "element" => "box_hover_style1", "value" => array("box-fade")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),	
			array(
				"type"				=> "zolo_number",
				"class"				=> "",
				"heading"			=> esc_html__("Title Font Size","apcore"),
				"param_name"		=> "contentboxtitle_size",
				"value"				=> "24",
				"suffix"			=> "PX",
				"edit_field_class"	=> "vc_column vc_col-sm-12",
			),					
			array(
				"type"				=> "zolo_padding",
				"heading"			=> "Title Padding",
				"param_name"		=> "boxtitlepad",
				"positions"			=> array(
					esc_html__("Top", "apcore")		=> "top",
					esc_html__("Bottom", "apcore")	=> "bottom",
					esc_html__("Left", "apcore")	=> "left",
					esc_html__("Right", "apcore")	=> "right",
				),
				"value"				=> "padding-top:10|padding-bottom:5|padding-left:0|padding-right:0",
				"edit_field_class"	=> "vc_column vc_col-sm-12 no-border-bottom",
			),									
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Title & Descriptions Color","apcore"),
				"description"		=> __("Choose Title & Descriptions Color","apcore"),
				"param_name"		=> "title_desc_color",
				"value"				=> "#333333", 				
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),			
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Title & Descriptions Hover Color","apcore"),
				"description"		=> __("Choose Title & Descriptions Hover Color","apcore"),
				"param_name"		=> "text_hover_corder",
				"value"				=> "#ffffff", 				
				"dependency"		=> array( "element" => "box_hover_style", "value" => array("box-fade","box-zoom","box-flip-vertical")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),
			array(
				"type"				=> "colorpicker",
				"class"				=> "",
				"heading"			=> __("Title & Descriptions Hover Color","apcore"),
				"description"		=> __("Choose Title & Descriptions Hover Color","apcore"),
				"param_name"		=> "text_hover_corder1",
				"value"				=> "#ffffff", 				
				"dependency"		=> array( "element" => "box_hover_style1", "value" => array("box-fade")),
				"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
			),					
			array(
				"type"				=> "vc_link",
				"class"				=> "",
				"heading"			=> __("Content Area Link","apcore"),
				"param_name"		=> "contentarealink",
				"description"		=> __("http://example.com","apcore")
			),
			array(
				"type"				=> "dropdown",
				"heading"			=> __( "Icon library", "apcore" ),
				"value"				=> array(
					__( "Font Awesome", "apcore" ) => "fontawesome",
					__( "Open Iconic", "apcore" ) => "openiconic",
					__( "Typicons", "apcore" ) => "typicons",
					__( "Entypo", "apcore" ) => "entypo",
					__( "Linecons", "apcore" ) => "linecons",
					__( "Mono Social", "apcore" ) => "monosocial",
					__( 'Linea', 'apcore' ) => 'linea',
				),
				"save_always"		=> true,
				"param_name"		=> "icon_family",
				"description"		=> __( "Select icon library.", "apcore" ),
				"group"				=> __( "Main content", "apcore" ),
			),
			array(
				'type'				=> 'iconpicker',
				"heading"			=> __('Icon', 'apcore'),
				"param_name"		=> 'icon_fontawesome',
				"value"				=> 'fa fa-adjust',
				'settings'			=> array( 'emptyIcon' => false, 'iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family', "value" => 'fontawesome'),
				'description'		=> __('Select icon from library.', 'apcore'),
				'group'				=> __( 'Main content', 'apcore' ),
			),	
			array(
				'type'				=> 'iconpicker',
				"heading"			=> __( 'Icon', 'apcore' ),
				"param_name"		=> 'icon_openiconic',
				"value"				=> 'vc-oi vc-oi-dial',
				'settings'			=> array('emptyIcon' => false, 'type' => 'openiconic', 'iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family','value' => 'openiconic'),
				'description'		=> __( 'Select icon from library.', 'apcore' ),
				'group'				=> __( 'Main content', 'apcore' ),
			),	
			array(
				'type'				=> 'iconpicker',
				"heading"			=> __( 'Icon', 'apcore' ),
				"param_name"		=> 'icon_typicons',
				"value"				=> 'typcn typcn-adjust-brightness',
				'settings'			=> array('emptyIcon' => false,'type' => 'typicons','iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family','value' => 'typicons'),
				'description'		=> __( 'Select icon from library.', 'apcore'),
				'group'				=> __( 'Main content', 'apcore' ),
			),
			array(
				'type'				=> 'iconpicker',
				"heading"			=> __( 'Icon', 'apcore' ),
				"param_name"		=> 'icon_entypo',
				"value"				=> 'entypo-icon entypo-icon-note',
				'settings'			=> array('emptyIcon' => false,'type' => 'entypo','iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family','value' => 'entypo'),
				'description'		=> __( 'Select icon from library.', 'apcore' ),
				'group'				=> __( 'Main content', 'apcore' ),
			),
			array(
				'type'				=> 'iconpicker',
				"heading"			=> __( 'Icon', 'apcore' ),
				"param_name"		=> 'icon_linecons',
				"value"				=> 'vc_li vc_li-heart',
				'settings'			=> array('emptyIcon' => false,'type' => 'linecons','iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family','value' => 'linecons'),
				'description'		=> __( 'Select icon from library.', 'apcore' ),
				'group'				=> __( 'Main content', 'apcore' ),
			),	
			array(
				'type'				=> 'iconpicker',
				"heading"			=> __( 'Icon', 'apcore' ),
				"param_name"		=> 'icon_monosocial',
				"value"				=> 'vc-mono vc-mono-fivehundredpx',
				'settings'			=> array('emptyIcon' => false,'type' => 'monosocial','iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family','value' => 'monosocial'),
				'description'		=> __( 'Select icon from library.', 'apcore' ),
				'group'				=> __( 'Main content', 'apcore' ),
			),	
			array(
				'type'				=> 'iconpicker',
				'heading'			=> __('Icon', 'apcore'),
				'param_name'		=> 'icon_linea',
				'value'				=> 'icon-basic-heart',
				'settings'			=> array( 'emptyIcon' => true, 'type' => 'linea', 'iconsPerPage' => 4000),
				'dependency'		=> array('element' => 'icon_family', 'value' => 'linea'),
				'description'		=> __('Select icon from library.', 'apcore'),
				'group'				=> __( 'Main content', 'apcore' ),
			),
			array(
				"type"				=> "textfield",
				"class"				=> "",
				"heading"			=> __("Content Box Title","apcore"),
				"description"		=> __("Enter Content Box Title","apcore"),
				"param_name"		=> "contentboxtitle",
				"value"				=> "This is Title",				
				"group"				=> __( "Main content", "apcore" ),
				//"admin_label"		=> true,
				"holder"			=> "div",
			),	
			array(
				"type"				=> "textarea",
				"class"				=> "",
				"heading"			=> __("Content Area","apcore"),
				"description"		=> __("Enter Content Area","apcore"),
				"param_name"		=> "contentboxarea",
				"value"				=> "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris quis elit nec sem laoreet tempor sit amet a quam.",				
				"group"				=> __( "Main content", "apcore" ),
				"holder"			=> "div",				
			),	
			array(
				"type"				=> "zolo_param_heading",
				"text"				=> esc_html__("Extra features", "apcore"),
				"param_name"		=> "subtitle_margin_heading",
				"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin",
			),
			array(
				"type"				=> "dropdown",
				"class"				=> "",
				"heading"			=> __("CSS Animation","apcore"),
				"param_name"		=> "contentboxanimation",
				"value"				=> apress_data_animations(),
				"description"		=> __("Select type of animation. Note: Works only in modern browsers.","apcore"),
				"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-8 no-top-margin",
			),  
			array(
				"type"				=> "textfield",
				"class"				=> "",
				"heading"			=> __("Delay","apcore"),
				"param_name"		=> "contentboxdelay",
				"value"				=> "500",
				"description"		=> __("Delay","apcore"),
				"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-4 no-top-margin",
			),			
			array(
				"type"				=> "zolo_video_link_param",
				"heading"			=> esc_html__("Video tutorial and theme documentation article","apcore"),
				"param_name"		=> "tutorials",
				"doc_link"			=> $doc_link,
				"video_link"		=> "https://youtu.be/3sFaLsVDXeo",
			),			
			array(
				"type"				=> "css_editor",
				"heading"			=> __( "CSS box", "apcore" ),
				"param_name"		=> "css",
				"group"				=> __( "Design Options", "apcore" ),
			),
		),
	) );		

}		