<?php 
/*-----------------------------------------------------------------------------------*/
/* Counter Circle
/*-----------------------------------------------------------------------------------*/

if ( ! defined( 'ABSPATH' ) ) { exit; }
class WPBakeryShortCode_Apress_Counter_Circle extends WPBakeryShortCode {}

$doc_link = 'http://apressthemes.com/apress/documentation';

if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
					"name"			=> __("Counter Circle",'apcore'),
					"base"			=> "apress_counter_circle",
					"class"			=> "",
					"weight"		=> 6,
					"category"		=> __( "Apress", "apcore"),
					"description"	=> __( "Present Counter Circle", "apcore"),
					"icon"			=> APRESS_EXTENSIONS_PLUGIN_URL . "vc_custom/assets/images/vc_icons/vc-icon-counter_circle.png",
					"params" => array(
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Filled Area Percentage",'apcore'),
							"description"		=> __("From 1 - 100. e.g - 42",'apcore'),
							"param_name"		=> "data_percent_value",
							"value"				=> __("42",'apcore'),							
							'admin_label'		=> true,
							'save_always'		=> true,
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Bar color",'apcore'),
							"description"		=> __("The color of the curcular bar.",'apcore'),
							"param_name"		=> "bar_color",
							"value"				=> '#ccc',	
							"edit_field_class"	=> "vc_column vc_col-sm-4 no-border-bottom",						
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Track color",'apcore'),
							"description"		=> __("The color of the track for the bar.",'apcore'),
							"param_name"		=> "track_color",
							"value"				=> '#f2f2f2',
							"edit_field_class"	=> "vc_column vc_col-sm-4 no-border-bottom",							
						),
						array(
							"type"				=> "colorpicker",
							"class"				=> "",
							"heading"			=> __("Scale color",'apcore'),
							"description"		=> __("The color of the scale lines.",'apcore'),
							"param_name"		=> "scale_color",
							"value"				=> '',		
							"edit_field_class"	=> "vc_column vc_col-sm-4 no-border-bottom",					
						),
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("Line Cap",'apcore'),
							"description"		=> __("Defines how the ending of the bar line looks like.",'apcore'),
							"param_name"		=> "line_cap",
							"value"				=> array (
								"Butt" => "butt", 
								"Round" => "round", 
								"Square" => "square" 
							), 							
						),
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Line Width",'apcore'),
							"description"		=> __("Width of the bar line, e.g- 10",'apcore'),
							"param_name"		=> "line_width",
							'step'				=> '1',
							'value'				=> '10',
							"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",							
						),
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Size",'apcore'),
							"description"		=> __("Size of the pie chart, e.g- 170",'apcore'),
							"param_name"		=> "size",
							'step'				=> '1',
							'value'				=> '170',
							"edit_field_class"	=> "vc_column vc_col-sm-6 no-border-bottom",
						),
						array(
							"type"				=> "dropdown",
							"class"				=> "",
							"heading"			=> __("Counter Circle Data",'apcore'),
							"description"		=> __("Choose the counter circlr style ( visual )",'apcore'),
							"param_name"		=> "c_circle_data",
							"value"				=> array ("Percentage Value" => "zt_circle_number", "Icon" => "zt_circle_icon", "Image" => "zt_circle_image", "Text" => "zt_circle_text" ), 							
							'group'				=> __( 'Main content', 'apcore' ),
						),
						array(
							'type'				=> 'dropdown',
							'heading'			=> __( 'Icon library', 'apcore' ),
							'value' => array(
								__( 'Font Awesome', 'apcore' ) => 'fontawesome',
								__( 'Open Iconic', 'apcore' ) => 'openiconic',
								__( 'Typicons', 'apcore' ) => 'typicons',
								__( 'Entypo', 'apcore' ) => 'entypo',
								__( 'Linecons', 'apcore' ) => 'linecons',
								__( 'Mono Social', 'apcore' ) => 'monosocial',
								__( 'Linea', 'apcore' ) => 'linea',
							),
							'save_always'		=> true,
							'param_name'		=> 'icon_family',
							'description'		=> __( 'Select icon library.', 'apcore' ),
							'group'				=> __( 'Main content', 'apcore' ),
							"dependency"		=> array( "element" => "c_circle_data", "value" => array("zt_circle_icon")),
						),
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __('Icon', 'apcore'),
							'param_name'		=> 'icon_fontawesome',
							'value'				=> 'fa fa-adjust',
							'settings'			=> array( 'emptyIcon' => false, 'iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family', 'value' => 'fontawesome'),
							'description'		=> __('Select icon from library.', 'apcore'),
							'group'				=> __( 'Main content', 'apcore' ),
						),	
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __( 'Icon', 'apcore' ),
							'param_name'		=> 'icon_openiconic',
							'value'				=> 'vc-oi vc-oi-dial',
							'settings'			=> array('emptyIcon' => false, 'type' => 'openiconic', 'iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family','value' => 'openiconic'),
							'description'		=> __( 'Select icon from library.', 'apcore' ),
							'group'				=> __( 'Main content', 'apcore' ),
						),	
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __( 'Icon', 'apcore' ),
							'param_name'		=> 'icon_typicons',
							'value'				=> 'typcn typcn-adjust-brightness',
							'settings'			=> array('emptyIcon' => false,'type' => 'typicons','iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family','value' => 'typicons'),
							'description'		=> __( 'Select icon from library.', 'apcore'),
							'group'				=> __( 'Main content', 'apcore' ),
						),
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __( 'Icon', 'apcore' ),
							'param_name'		=> 'icon_entypo',
							'value'				=> 'entypo-icon entypo-icon-note',
							'settings'			=> array('emptyIcon' => false,'type' => 'entypo','iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family','value' => 'entypo'),
							'description'		=> __( 'Select icon from library.', 'apcore' ),
							'group'				=> __( 'Main content', 'apcore' ),
						),
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __( 'Icon', 'apcore' ),
							'param_name'		=> 'icon_linecons',
							'value'				=> 'vc_li vc_li-heart',
							'settings'			=> array('emptyIcon' => false,'type' => 'linecons','iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family','value' => 'linecons'),
							'description'		=> __( 'Select icon from library.', 'apcore' ),
							'group'				=> __( 'Main content', 'apcore' ),
						),	
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __( 'Icon', 'apcore' ),
							'param_name'		=> 'icon_monosocial',
							'value'				=> 'vc-mono vc-mono-fivehundredpx',
							'settings'			=> array('emptyIcon' => false,'type' => 'monosocial','iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family','value' => 'monosocial'),
							'description'		=> __( 'Select icon from library.', 'apcore' ),
							'group'				=> __( 'Main content', 'apcore' ),
						),
						array(
							'type'				=> 'iconpicker',
							'heading'			=> __('Icon', 'apcore'),
							'param_name'		=> 'icon_linea',
							'value'				=> 'icon-basic-heart',
							'settings'			=> array( 'emptyIcon' => true, 'type' => 'linea', 'iconsPerPage' => 4000),
							'dependency'		=> array('element' => 'icon_family', 'value' => 'linea'),
							'description'		=> __('Select icon from library.', 'apcore'),
							'group'				=> __( 'Main content', 'apcore' ),
						),
						array(
							"type"				=> "attach_image",
							"heading"			=> __("Counter Circle Image", "apcore"),
							"param_name"		=> "circle_image",
							"value"				=> "",
							"dependency"		=> array( "element" => "c_circle_data", "value" => array("zt_circle_image")),
							'group'				=> __( 'Main content', 'apcore' ),
						),					
						array(
							"type"				=> "textfield",
							"class"				=> "",
							"heading"			=> __("Counter Circle Text",'apcore'),
							"param_name"		=> "circle_text",
							"value"				=> 'APRESS',
							"description"		=> __("Insert text value",'apcore'),
							"dependency"		=> array( "element" => "c_circle_data", "value" => array("zt_circle_text")),
							'group'				=> __( 'Main content', 'apcore' ),
						),					
						array(
							'type'				=> 'zolo_number',
							"heading"			=> __("Circle Font Size",'apcore'),
							"param_name"		=> "circlefontsize",
							'step'				=> '1',
							'value'				=> '26',
							'suffix'			=> 'px',
							"dependency"		=> array( "element" => "c_circle_data", "value" => array("zt_circle_icon","zt_circle_number","zt_circle_text")),
						),
						array(
							"type"				=> "colorpicker",
							"heading"			=> __("Circle Font Color",'apcore'),
							"param_name"		=> "circlefontcolor",
							"value"				=>'#777777',
							"dependency"		=> array( "element" => "c_circle_data", "value" => array("zt_circle_icon","zt_circle_number","zt_circle_text")),
						),
						array(
							'type'				=> 'zolo_video_link_param',
							'heading'			=> esc_html__('Video tutorial and theme documentation article','apcore'),
							'param_name'		=> 'tutorials',
							'doc_link'			=> $doc_link,
							'video_link'		=> 'https://youtu.be/TwppCdF-hGE',
						),
						
					),
				) );		
		
			}		