<?php 
/*-----------------------------------------------------------------------------------*/
/* Pricing Table
/*-----------------------------------------------------------------------------------*/

if ( ! defined( 'ABSPATH' ) ) { exit; }
class WPBakeryShortCode_Apress_Pricing_Table extends WPBakeryShortCode {}

$doc_link = 'http://apressthemes.com/apress/documentation';

if ( function_exists( 'vc_map' ) ) {
		vc_map( array(
			"name"			=> __("Pricing Table", 'apcore'),
			"base"			=> "apress_pricing_table",
			"weight"		=> 19,
			"class"			=> "",
			"category"		=> __( "Apress", "apcore"),
			"description"	=> __( "Amazing Pricing Table", "apcore"),
			"icon"			=> APRESS_EXTENSIONS_PLUGIN_URL . "vc_custom/assets/images/vc_icons/vc-icon-pricing-table.png",
				"params" => array(					
				array(
					'type'        => 'radio_image_select',
					'heading'     => esc_html__( 'Style', 'apcore' ),
					'param_name'  => 'style',
					'simple_mode' => false,
					'options'     => array(
						'pricing_table_style1' => array(
							'tooltip' => esc_attr__('Pricing Table Style1','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/pricing_table/pricing_table_style1.jpg'
						),
						'pricing_table_style2' => array(
							'tooltip' => esc_attr__('Pricing Table Style2','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/pricing_table/pricing_table_style2.jpg'
						),
						'pricing_table_style3' => array(
							'tooltip' => esc_attr__('Pricing Table Style3','apcore'),
							'src' => APRESS_EXTENSIONS_PLUGIN_URL . 'vc_custom/assets/images/pricing_table/pricing_table_style3.jpg'
						),
						
					),
					'admin_label'		=> true,
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Content Alignment', 'apcore'),
					'param_name'		=> 'content_alignment',
					'value'				=> 'center',
					'options'			=> array(
						esc_html__('Left', 'apcore')	=> 'left',
						esc_html__('Center', 'apcore') => 'center',
						esc_html__('Right', 'apcore')	=> 'right'
					),
				),	
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Select Color Scheme",'apcore'),
					"param_name"	=> "color_scheme",
					"value"			=> array(
						__("Default Button Color",'apcore') => "default_button_color_scheme",
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') 	=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') 	=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') 	=> "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
				),	
				
				array(
					"type"				=> "colorpicker",
					"class"				=> "",
					"heading"			=> __("Main background Color",'apcore'),
					"param_name"		=> "main_bg_color",
					"value"				=> '',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
				),
				array(
					"type"				=> "colorpicker",
					"class"				=> "",
					"heading"			=> __("Highlight Color",'apcore'),
					"param_name"		=> "highlight_color",
					"value"				=> '',
					"description"		=> __("Select highlight color.",'apcore'),
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
				),
				
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Title', 'apcore'),
					'param_name'		=> 'title',
					'value'				=> esc_html__('Pricing Title','apcore'),
					'admin_label'		=> true,
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Currency symbol', 'apcore'),
					'param_name'		=> 'currency_symbol',
					'value'				=> esc_html__('$','apcore'),
					'description'		=> esc_html__('This option allows you set any currency symbol you need','apcore'),
					'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc apress-number-wrap',
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Price', 'apcore'),
					'param_name'		=> 'price',
					'value'				=> esc_html__('29','apcore'),
					'description'		=> esc_html__('This option allows you set the price for your table','apcore'),
					'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc apress-number-wrap',
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Recurring fee', 'apcore'),
					'param_name'		=> 'recurring_fee',
					'value'				=> esc_html__('mo','apcore'),
					'description'		=> esc_html__('This option allows you to set the recurring fee for your pricing table.','apcore'),
					'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc apress-number-wrap',
				),
				array(
					'type'				=> 'textarea_html',
					'heading'			=> esc_html__('Content/Features', 'apcore'),
					'param_name'		=> 'content',
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Pricing box as featured', 'apcore'),
					'param_name'		=> 'featured_pricing',
					'value'				=> 'on',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
				),
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Box Swing On Hover', 'apcore'),
					'param_name'		=> 'pricing_box_swing',
					'value'				=> 'on',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
				),
				 
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Activate Shadow', 'apcore'),
					'param_name'		=> 'pricing_shadow',
					'value'				=> 'yes',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-4 crum_vc',
				),
				array(
					'type'				=> 'zolo_number',
					'heading'			=> esc_html__('Minimum Height For Price Box', 'apcore'),
					'param_name'		=> 'price_table_height',
					'value'				=> '',
					'suffix' 			=> 'px',
					'description'		=> esc_html__('Adjust height of your price box.','apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Extra features', 'apcore'),
					'param_name'		=> 'subtitle_margin_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
				),
				array(
					"type"				=> "dropdown",
					"class"				=> "",
					"heading"			=> __("CSS Animation",'apcore'),
					"param_name"		=> "data_animation",
					"value"				=> apress_data_animations(),
					"description"		=> __("Select type of animation. Note: Works only in modern browsers.",'apcore'),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-8 no-top-margin",
				),  
				array(
					"type"				=> "textfield",
					"class"				=> "",
					"heading"			=> __("Delay","apcore"),
					"param_name"		=> "data_delay",
					"value"				=> "500",
					"description"		=> __("Delay","apcore"),
					"edit_field_class"	=> "apress-heading-param-wrapper vc_column vc_col-sm-4 no-top-margin",
				),
				array(
					"type"				=> "textfield",
					"heading"			=> __("Extra class name", "apcore"),
					"param_name"		=> "class",
					"description"		=> __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "apcore")
				),
				array(
					'type'				=> 'zolo_video_link_param',
					'heading'			=> esc_html__('Video tutorial and theme documentation article','apcore'),
					'param_name'		=> 'tutorials',
					'doc_link'			=> $doc_link,
					'video_link'		=> 'https://youtu.be/qRI5-cG9i0c',
				),
				
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Box Etyling Enable', 'apcore'),
					'param_name'		=> 'box_styling_enable',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Box Styling', 'apcore'),
					'param_name'		=> 'box_styling_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),		
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Background Color Scheme",'apcore'),
					"param_name"	=> "box_bg_color_scheme",
					"value"			=> array(
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') => "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') => "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') => "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					"type"				=> "colorpicker",
					"class"				=> "",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "box_bg_color",
					"value"				=> '',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'box_bg_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading' 			=> __("Opacity",'apcore'),
					'param_name'		=> 'box_bg_color_opacity',
					"value" 			=> 1,
					"min" 				=> 0.0,
					"max" 				=> 1.0,
					"step" 				=> 0.1,
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),	
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "box_bg_image",
					"value"				=> "",
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Box Hover Styling', 'apcore'),
					'param_name'		=> 'box_hover_styling_heading',
					'edit_field_class'	=> 'apress-heading-param-wrapper vc_column vc_col-sm-12 no-top-margin',
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					"type"			=> "dropdown",
					"heading"		=> __("Background Color Scheme",'apcore'),
					"param_name"	=> "box_hover_bg_color_scheme",
					"value"			=> array(
						__("Default Button Color",'apcore') => "default_button_color_scheme",
						__("Primary Color",'apcore') 	=> "primary_color_scheme",
						__("Color Scheme 1",'apcore') 	=> "color_scheme1",
						__("Color Scheme 2",'apcore') 	=> "color_scheme2",
						__("Gradient Scheme 1",'apcore') 	=> "gradient_scheme1",
						__("Gradient Scheme 2",'apcore') 	=> "gradient_scheme2",
						__("Gradient Scheme 3",'apcore') 	=> "gradient_scheme3",
						__("Custom Color",'apcore') 	=> "design_your_own"
					),
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "box_hover_bg_color",
					"value"				=> '',
					"description"		=> __("Select normal background color.",'apcore'),
					'dependency'		=> array('element' => 'box_hover_bg_color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type' 				=> 'zolo_number',
					'heading' 			=> __("Opacity",'apcore'),
					'param_name'		=> 'box_hover_bg_color_opacity',
					"value" 			=> 1,
					"min" 				=> 0.0,
					"max" 				=> 1.0,
					"step" 				=> 0.1,
					'suffix'			=> 'px',
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),	
				array(
					"type"				=> "attach_image",
					"class"				=> "",
					"heading"			=> __("Image", "apcore"),
					"param_name"		=> "box_hover_bg_image",
					"value"				=> "",
					'dependency'		=> array('element' => 'box_styling_enable', 'value' => array('yes')),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Font Color",'apcore'),
					"param_name"		=> "box_hover_text_color",
					"value"				=> '',
					"description"		=> __("Select text color.",'apcore'),
					'group'				=> esc_html__('Box Styling', 'apcore'),
				),
				array(
					'type'				=> 'textfield',
					'heading'			=> esc_html__('Label', 'apcore'),
					'param_name'		=> 'label',
					'value'				=> '',
					'group'				=> esc_html__('Label', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Label Typography', 'apcore'),
					'param_name'		=> 'label_typo_heading',
					'group'				=> esc_html__('Label', 'apcore'),
				),				
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'label_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Label', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'label_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Label', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'label_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'label_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Label', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "label_bg_color",
					"value"				=> '',
					'group'				=> esc_html__('Label', 'apcore'),
				),	
				array(
					'type'				=> 'zolo_single_checkbox',
					'heading'			=> esc_html__('Icon', 'apcore'),
					'param_name'		=> 'enable_icon',
					'value'				=> 'no',
					'options'			=> array(
						'yes'			=> array(
							'on'				=> 'Yes',
							'off'				=> 'No',
						),
					),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Icon to display', 'apcore'),
					'param_name'		=> 'icon_to_display',
					'value'				=> 'icon',
					'options'			=> array(
						esc_html__('Icon', 'apcore')	=> 'icon',
						esc_html__('Image', 'apcore')	=> 'image',
					),
					'dependency'		=> array('element' => 'enable_icon', 'value' => 'yes'),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type' => 'dropdown',
					'heading' => __( 'Icon library', 'apcore' ),
					'value' => array(
						__( 'Font Awesome', 'apcore' ) => 'fontawesome',
						__( 'Open Iconic', 'apcore' ) => 'openiconic',
						__( 'Typicons', 'apcore' ) => 'typicons',
						__( 'Entypo', 'apcore' ) => 'entypo',
						__( 'Linecons', 'apcore' ) => 'linecons',
						__( 'Mono Social', 'apcore' ) => 'monosocial',
						__( 'Linea', 'apcore' ) 	=> 'linea',
					),
					'save_always'=> true,
					'param_name' => 'icon_family',
					'description'=> __( 'Select icon library.', 'apcore' ),
					'dependency'		=> array('element' => 'icon_to_display', 'value' => 'icon'),
					'group'		=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type' => 'iconpicker',
					'heading' => __('Icon', 'apcore'),
					'param_name' => 'icon_fontawesome',
					'value' => 'fa fa-adjust',
					'settings' => array( 'emptyIcon' => false, 'iconsPerPage' => 4000),
					'dependency' => array('element' => 'icon_family', 'value' => 'fontawesome'),
					'description' => __('Select icon from library.', 'apcore'),
					'group'		=> esc_html__('Icon', 'apcore'),					
				),	
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'apcore' ),
					'param_name' => 'icon_openiconic',
					'value' => 'vc-oi vc-oi-dial',
					'settings' => array('emptyIcon' => false, 'type' => 'openiconic', 'iconsPerPage' => 4000),
					'dependency' => array('element' => 'icon_family','value' => 'openiconic'),
					'description' => __( 'Select icon from library.', 'apcore' ),
					'group'		=> esc_html__('Icon', 'apcore'),	
				),	
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'apcore' ),
					'param_name' => 'icon_typicons',
					'value' => 'typcn typcn-adjust-brightness',
					'settings' => array('emptyIcon' => false,'type' => 'typicons','iconsPerPage' => 4000),
					'dependency' => array('element' => 'icon_family','value' => 'typicons'),
					'description' => __( 'Select icon from library.', 'apcore'),
					'group'		=> esc_html__('Icon', 'apcore'),	
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'apcore' ),
					'param_name' => 'icon_entypo',
					'value' => 'entypo-icon entypo-icon-note',
					'settings' => array('emptyIcon' => false,'type' => 'entypo','iconsPerPage' => 4000),
					'dependency' => array('element' => 'icon_family','value' => 'entypo'),
					'description' => __( 'Select icon from library.', 'apcore' ),
					'group'		=> esc_html__('Icon', 'apcore'),	
				),
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'apcore' ),
					'param_name' => 'icon_linecons',
					'value' => 'vc_li vc_li-heart',
					'settings' => array('emptyIcon' => false,'type' => 'linecons','iconsPerPage' => 4000),
					'dependency' => array('element' => 'icon_family','value' => 'linecons'),
					'description' => __( 'Select icon from library.', 'apcore' ),
					'group'		=> esc_html__('Icon', 'apcore'),	
				),	
				array(
					'type' => 'iconpicker',
					'heading' => __( 'Icon', 'apcore' ),
					'param_name' => 'icon_monosocial',
					'value' => 'vc-mono vc-mono-fivehundredpx',
					'settings' => array('emptyIcon' => false,'type' => 'monosocial','iconsPerPage' => 4000),
					'dependency' => array('element' => 'icon_family','value' => 'monosocial'),
					'description' => __( 'Select icon from library.', 'apcore' ),
					'group'		=> esc_html__('Icon', 'apcore'),	
				),
				array(
					'type'				=> 'iconpicker',
					'heading'			=> __('Icon', 'apcore'),
					'param_name'		=> 'icon_linea',
					'value'				=> 'icon-basic-heart',
					'settings'			=> array( 'emptyIcon' => true, 'type' => 'linea', 'iconsPerPage' => 4000),
					'dependency'		=> array('element' => 'icon_family', 'value' => 'linea'),
					'description'		=> __('Select icon from library.', 'apcore'),
					'group'				=> __( 'Icon', 'apcore' ),
				),
				array(
					'type'				=> 'attach_image',
					'heading'			=> esc_html__('Upload Image', 'apcore'),
					'param_name'		=> 'upload_image',
					'dependency'		=> array('element' => 'icon_to_display', 'value' => array('image')),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					'type' => 'zolo_number',
					'heading' => esc_html__('Icon size','apcore'),
					'param_name' => 'icon_size',
					'step' => '1',
					'suffix' => 'px',
					'dependency'		=> array('element' => 'enable_icon', 'value' => 'yes'),
					'group'				=> esc_html__('Icon', 'apcore'),
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Button text",'apcore'),
					"param_name" => "button_text",
					"value" => 'Button text',
					"description" => __("Enter the button text",'apcore'),
					'group'				=> esc_html__('Button', 'apcore'),
					),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Button Size",'apcore'),
					"param_name" => "button_size",
					"value" => array (
						__("Small",'apcore') => "small",
						__("Medium",'apcore') => "medium", 
						__("Large",'apcore') => "large",
						__("Design Your Own",'apcore') 	=> "design_your_own"
					 ),
					 'group'				=> esc_html__('Button', 'apcore'), 
					),	
				array(
					'type' => 'zolo_number',
					'heading' => esc_html__('Padding Top & Bottom','apcore'),
					'param_name' => 'padding_top_bottom',
					'step' => '1',
					'value'	=> '15',
					'suffix' => 'px',
					'dependency'		=> array('element' => 'button_size', 'value' => 'design_your_own'),
					'group'				=> esc_html__('Button', 'apcore'), 
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
				),
				array(
					'type' => 'zolo_number',
					'heading' => esc_html__('Padding Right & Left','apcore'),
					'param_name' => 'padding_right_left',
					'step' => '1',
					'value'	=> '25',
					'suffix' => 'px',
					'dependency'		=> array('element' => 'button_size', 'value' => 'design_your_own'),
					'group'				=> esc_html__('Button', 'apcore'), 
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
				),				
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Shape', 'apcore'),
					'param_name'		=> 'button_shape',
					'value'				=> 'square',
					'options'			=> array(
						esc_html__('Square', 'apcore')	=> 'square',
						esc_html__('Rounded', 'apcore') => 'rounded',
						esc_html__('Round', 'apcore')	=> 'round'
					),
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					"type" => "dropdown",
					"heading" => __("Select Button Hover Style",'apcore'),
					"param_name" => "button_hover_style",
					'value' 	=> array(
						__("Hover Style 1 - Fade",'apcore') 			=> "hoverstyle1",
						__("Hover Style 2 - Top To Bottom",'apcore') 	=> "hoverstyle2",
						__("Hover Style 3 - Bottom to Top",'apcore') 	=> "hoverstyle3",
						__("Hover Style 4 - Left To Right",'apcore') 	=> "hoverstyle4",
						__("Hover Style 5 - Right To Left",'apcore') 	=> "hoverstyle5",
					),
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					"type" => "vc_link",
					"class" => "",
					"heading" => __("Button Link",'apcore'),
					"param_name" => "button_link",
					"description" => __("http://example.com",'apcore'),
					'group'				=> esc_html__('Button', 'apcore'),
				 ),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Background Color",'apcore'),
					"param_name"		=> "button_bg_color",
					"value"				=> '#5295ea',
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					"type"				=> "colorpicker",
					"heading"			=> __("Hover Background Color",'apcore'),
					"param_name"		=> "button_bg_color_h",
					"value"				=> '#3b65d6',
					"dependency"		=> array("element" => "color_scheme", "value" => array("design_your_own")),
					"edit_field_class"	=> "vc_column vc_col-sm-6 crum_vc apress-number-wrap",
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Text Color",'apcore'),
					"param_name" => "button_text_color",
					"value" => '#ffffff',
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('Button', 'apcore'),
					
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Hover Text Color",'apcore'),
					"param_name" => "button_text_color_h",
					"value" => '#ffffff',
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Border Color",'apcore'),
					"param_name" => "button_border_color",
					"value" => '#5295ea',
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('Button', 'apcore'),
					
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Hover Border Color",'apcore'),
					"param_name" => "button_border_color_h",
					"value" => '#3b65d6',
					'dependency'		=> array('element' => 'color_scheme', 'value' => array('design_your_own')),
					'edit_field_class'	=> 'vc_column vc_col-sm-6 crum_vc apress-number-wrap',
					'group'				=> esc_html__('Button', 'apcore'),
				),
								
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Title Typography', 'apcore'),
					'param_name'		=> 'title_typo_heading',
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),				
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'title_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'tag' => 'h2',
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'title_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'title_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'title_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Title Typography', 'apcore'),
				),

				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Currency symbol Typography', 'apcore'),
					'param_name'		=> 'currency_symbol_typo_heading',
					'group'				=> esc_html__('Currency symbol', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'currency_symbol_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Currency symbol', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'currency_symbol_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Currency symbol', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'currency_symbol_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'currency_symbol_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Currency symbol', 'apcore'),
				),
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Price Typography', 'apcore'),
					'param_name'		=> 'price_typo_heading',
					'group'				=> esc_html__('Price Typo', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'price_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Price Typo', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'price_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Price Typo', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'price_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'price_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Price Typo', 'apcore'),
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Recurring fee Typography', 'apcore'),
					'param_name'		=> 'recurring_fee_typo_heading',
					'group'				=> esc_html__('Recurring fee', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'recurring_fee_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Recurring fee', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'recurring_fee_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Recurring fee', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'recurring_fee_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'recurring_fee_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Recurring fee', 'apcore'),
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Content/Features Typography', 'apcore'),
					'param_name'		=> 'content_features_typo_heading',
					'group'				=> esc_html__('Content/Features Typo', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'content_features_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'tag' => 'div',
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
							'color',
						),
					),
					'group'				=> esc_html__('Content/Features Typo', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'content_features_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Content/Features Typo', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'content_features_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'content_features_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Content/Features Typo', 'apcore'),
				),
				
				array(
					'type'				=> 'zolo_param_heading',
					'text'				=> esc_html__('Button Typography', 'apcore'),
					'param_name'		=> 'button_typo_heading',
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					'type'				=> 'zolo_font_container',
					'heading'			=> '',
					'param_name'		=> 'button_font_options',
					'settings'				=> array(
						'fields'				=> array(
							'font_size',							
							'line_height',
							'letter_spacing',
							'font_style',
						),
					),
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					'type'				=> 'zolo_radio_advanced',
					'heading'			=> esc_html__('Custom font family', 'apcore'),
					'param_name'		=> 'button_google_fonts',
					'value'				=> 'no',
					'options'			=> array(
						esc_html__('Yes', 'apcore')	=> 'yes',
						esc_html__('No', 'apcore') => 'no',
					),
					'edit_field_class'	=> 'vc_column vc_col-sm-12 no-border-bottom',
					'group'				=> esc_html__('Button', 'apcore'),
				),
				array(
					'type'				=> 'google_fonts',
					'param_name'		=> 'button_custom_fonts',
					'settings'			=> array(
						'fields'			=> array(
							'font_family_description'	=> esc_html__('Select font family.', 'apcore'),
							'font_style_description'	=> esc_html__('Select font style.', 'apcore'),
						),
					),
					'dependency' => array( 'element' => 'button_google_fonts', 'value' => 'yes'),
					'group'				=> esc_html__('Button', 'apcore'),
				),					
				),
				
			//"js_view" => 'VcColumnView'
			) 
		);		
		
	}		